/**
* \file: e_sdc_ecm_log.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: sdc-ecm-engine
*
* \author: Christoph Gellner (cgellner@de.adit-jv.com)
*
* \copyright (c) 2018 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
***********************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "e_sdc_ecm_log.h"

#define HEXDUMP_BYTE_FORMAT " %02x" /* length is at most HEXDUMP_BYTE_FORMAT_LEN */
#define HEXDUMP_BYTE_FORMAT_LEN 3
#define HEXDUMP_BYTES_PER_LINE 32
#define HEXDUMP_LINE_LEN (HEXDUMP_BYTE_FORMAT_LEN * HEXDUMP_BYTES_PER_LINE)

void sdc_ecm_hexdump_data(const char *name, int desired_level,
                          const uint8_t *data, size_t len)
{
    if (loglevel >= desired_level) {
        const uint8_t *data_ptr = data;
        size_t remaining_len = len;
        char line_buffer[HEXDUMP_LINE_LEN + 1];
        char byte_buffer[HEXDUMP_BYTE_FORMAT_LEN + 1];

        sdc_ecm_log("%s - hexdump start - length %zu", name, len);

        while (remaining_len > 0) {
            memset(line_buffer, '\0', sizeof(line_buffer));

            /* can we put an additional char to that line */
            while ((remaining_len > 0) &&
                   (strlen(line_buffer) <= (HEXDUMP_LINE_LEN - HEXDUMP_BYTE_FORMAT_LEN))) {

                snprintf(byte_buffer, sizeof(byte_buffer), HEXDUMP_BYTE_FORMAT, *data_ptr);

                strcat(line_buffer, byte_buffer);
                remaining_len--;
                data_ptr++;
            }

            /* output line */
            sdc_ecm_log("%s", line_buffer);
        }

        sdc_ecm_log("%s - hexdump end", name);
    }
}
